from typing import List, Optional, Tuple

from axelrod._strategy_utils import detect_cycle

from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

def is_alternator(history: List[Action]) -> bool:
    for i in range(len(history) - 1):
        if history[i] == history[i + 1]:
            return False
    return True

class AlternatorHunter(Player):
    """A player who hunts for alternators.

    Names:

    - Alternator Hunter: Original name by Karol Langner
    """

    name = "Alternator Hunter"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self) -> None:
        super().__init__()
        self.is_alt = False

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if len(opponent.history) < 6:
            return C
        if len(self.history) == 6:
            self.is_alt = is_alternator(opponent.history)
        if self.is_alt:
            return D
        return C